@extends('framework::frontend.layouts.app')

@section('meta_title', $projectCategory->meta_title)
@section('meta_description', $projectCategory->meta_description)
@section('meta_index', $projectCategory->meta_index)
@section('meta_canonical', $projectCategory->meta_canonical)
@section('meta_image', asset($projectCategory->getPrimaryImage(['preset' => 'large'])))
@section('meta_schema'){!! SEO::getMetaSchemaForProject($projectCategory) !!}@endsection

@section('header_class', $projectCategory->getHeaderClass())
@section('page_css', $projectCategory->css)
@section('page_javascript')
    {!! $projectCategory->js !!}
@endsection

@section('content')
    <div class="container py-4">
        <div class="row">
            <div class="col">
                <div class="projects">

                    @if(!empty($projectCategory->content))
                        <div class="row mb-4">
                            <div class="col">
                                {!! $projectCategory->content !!}
                            </div>
                        </div>
                    @endif

                    @if (isset($projects) && count($projects) > 0)
                        <div class="row">
                            @foreach($projects as $key => $project)
                                @include('project::frontend.partials.project')
                            @endforeach
                        </div>
                        {{ $projects->links('framework::frontend.layouts.partials.pagination') }}
                    @endif

                </div>
            </div>
        </div>
    </div>
@stop
