@php($relatedProjects = $project->getRelatedByRandom())

@if($relatedProjects && count($relatedProjects))
    <section class="related-projects pt-5 pb-5">
        <div class="container">

            <h2 class="text-md-center mb-5">
                Related Projects
            </h2>

            <div class="row">
                @foreach($relatedProjects as $relatedProject)
                    <div class="col-md-6 col-lg-3">

                        <article class="related-project card mb-4 lg-md-0">

                            <div class="card-img-top">
                                <a class="d-block" href="{{ route('frontend.project.show', $relatedProject->slug) }}">
                                    <img
                                        class="img-fluid mx-auto d-block w-100"
                                        src="{{ $relatedProject->getPrimaryImage(['preset' => 'small']) }}"
                                        alt="{{ $relatedProject->name }}"
                                    />
                                </a>
                            </div>

                            <div class="card-body">
                                <h5 class="card-title">
                                    <a class="card-link"
                                       href="{{ route('frontend.project.show', $relatedProject->slug) }}"
                                    >
                                        {{ $relatedProject->name }}
                                    </a>
                                </h5>
                            </div>

                        </article>

                    </div>
                @endforeach
            </div>

        </div>
    </section>
@endif
