# Changelog

All notable changes to `bongo/project` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.12] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` - Cursor IDE guidance with project structure, service provider patterns, model architecture, and coding conventions
  - `CLAUDE.md` - Claude Code quick reference with commands, architecture summary, key files, and common tasks
  - `ARCHITECTURE.md` - Detailed architecture with directory structure, database schema, lifecycle flows, and extension guides
  - `.github/copilot-instructions.md` - GitHub Copilot code templates and common patterns for CRUD, events, views
  - `README.md` - Enhanced user-facing documentation with installation, configuration, and usage examples

## [3.0.11] - 2025-11-24

### Added
- **Individual Page Schema**: Added per-project JSON-LD schema support for enhanced SEO
  - Migration `2025_01_01_000008_add_schema_column_to_projects_table.php` adds `schema` text column to `projects` table
  - `Project` model updated with `schema` in `$fillable` array
  - Backend edit form (`backend/edit.blade.php`) updated with schema editor tab
  - Schema builder checks for and includes per-project schema if field is not empty
  - Allows custom structured data for individual projects alongside global schema

## [3.0.10] - 2025-11-20

### Changed
- **Builder Captcha Validation**: Updated builder view to use new custom captcha package JavaScript validation
  - Simplified captcha integration in `frontend/builder.blade.php`
  - Improved form validation flow

## [3.0.9] - 2025-11-03

### Fixed
- **Schema Updates**: Fixed schema rendering in frontend views
  - Updated `frontend/category/show.blade.php` schema output
  - Updated `frontend/show.blade.php` schema output

## [3.0.8] - 2025-02-24

### Changed
- **Date Cast**: Updated `Project` model to use new date cast format
  - Changed from old date cast to framework's new `Date` cast class
  - Ensures consistent date handling across application

## [3.0.7] - 2024-10-07

### Changed
- **Authentication**: Updated `auth.json` to use new credentials for package repository access

## [3.0.6] - 2024-06-03

### Fixed
- **HasRelated Trait**: Updated previous/next functionality to retrieve only active records
  - `getPrevious()` method now filters by `status = Project::ACTIVE`
  - `getNext()` method now filters by `status = Project::ACTIVE`
  - Prevents pending/inactive projects from appearing in navigation
  - Affects both posts and projects packages

## [3.0.5] - 2024-04-08

### Added
- **HTML Minification**: Added automatic full-page HTML minification middleware to frontend routes
  - New `minifyHtml` middleware added to frontend route group
  - Improves performance and produces cleaner HTML output
  - Beta feature requiring testing

### Changed
- **Frontend Routes**: Updated middleware stack for frontend routes
  - Routes now use: `hasRedirects`, `hasShortCodes`, `minifyHtml`

## [3.0.4] - 2024-03-18

### Added
- **Article Schema**: Implemented Schema.org Article structured data for projects
  - Added JSON-LD markup to project frontend views
  - Enhances SEO with rich snippets for search engines
  - Includes article metadata (title, description, author, published date)

## [3.0.3] - 2023-08-07

### Added
- **Transparent/Sticky Header**: Added header display options to projects
  - New `header_transparent` boolean field for transparent header on project pages
  - New `header_sticky` boolean field for sticky header behavior
  - Allows per-project control of header presentation

## [3.0.2] - 2023-07-03

### Added
- **Projects Widget**: Created widget functionality for displaying projects in sidebar/sections
  - Enables embedding project lists in custom layouts
  - Supports filtering and display options

## [3.0.1] - 2023-05-01

### Added
- **Cover Image Support**: Added cover image functionality to projects
  - Separate from featured image for different display contexts
  - Allows hero-style images on project pages

## [3.0.0] - 2023-04-24

### Changed
- **Laravel 10 & PHP 8.2 Upgrade**: Updated package for Laravel 10 and PHP 8.2 compatibility
  - Updated dependencies to Laravel 10 contracts
  - Updated code for PHP 8.2 syntax and features
  - Tested and verified compatibility across framework

### Upgrade Notes
- Requires PHP 8.2+
- Requires Laravel 10+
- Run migrations after upgrading

## [2.0.20] - 2023-02-20

### Changed
- **Editor Config**: Updated `.editorconfig` file with consistent formatting rules

## [2.0.19] - 2023-01-23

### Changed
- **Timestamp Display**: Updated "last saved" timestamp to use date format instead of relative time
  - Backend views now show formatted date/time for last update
  - Improves clarity for admin users

## [2.0.18] - 2023-01-23

### Added
- **Timestamp on Save**: Added visual feedback showing when project was last saved
  - Displays timestamp in admin interface after successful save
  - Helps editors track recent changes

## [2.0.17] - 2023-01-23

### Added
- **Data Table Buttons**: Enhanced data table interface with improved button styling and layout
  - Better action button placement in project list table
  - Improved UX for bulk actions

## [2.0.16] - 2023-01-10

### Added
- **Original File Names**: Image uploads now preserve original file names
  - Helps with organization and identification
  - File names sanitized for web-safe usage

## [2.0.15] - 2023-01-09

### Added
- **Automatic Sitemap Generation**: Projects automatically update sitemap on create/update/delete
  - `UpdateSitemap` listener registered for `ProjectCreated`, `ProjectUpdated`, `ProjectDeleted` events
  - Ensures search engines have up-to-date project URLs
  - Sitemap regenerates automatically without manual intervention

## [2.0.14] - 2022-12-06

### Added
- **Default Section**: Added ability to set default section/category for new projects
  - Streamlines project creation workflow
  - Default can be configured in settings

## [2.0.13] - 2022-11-21

### Added
- **Company Shortcodes**: Support for company information shortcodes in project content
  - Enables dynamic content replacement (e.g., `{company_name}`, `{company_phone}`)
  - Centralizes company info management

## [2.0.12] - 2022-08-08

### Added
- **Shortcodes Support**: Added `hasShortCodes` middleware to frontend routes
  - Enables shortcode processing in project content
  - Supports custom content placeholders and dynamic values

## [2.0.11] - 2022-05-30

### Added
- **Code Settings**: Added code editor settings files to repository
  - Ensures consistent development environment
  - Includes IDE configurations

## [2.0.10] - 2022-03-21

### Added
- **Module Index Meta**: Added dedicated meta title and description fields for project index page
  - Separate SEO optimization for project listing page vs individual projects
  - Improves search engine visibility of project index

## [2.0.9] - 2022-02-21

### Added
- **HasRelated Trait**: Implemented previous/next/random related project functionality
  - `getPrevious()`: Get chronologically previous project in same category
  - `getNext()`: Get chronologically next project in same category
  - `getRelatedByRandom(int $limit)`: Get random related projects from same categories
  - Enhances project navigation and content discovery
  - Uses session to remember selected category context

## [2.0.8] - 2022-02-07

### Added
- **Package Toggle**: Added ability to enable/disable project package from admin settings
  - Provides granular control over active packages
  - Registered `PackageSeeder` for database package record

## [2.0.7] - 2021-12-14

### Changed
- **Flex Box Layout**: Updated frontend layouts to use CSS flexbox
  - Modern responsive design approach
  - Better cross-browser compatibility
  - Improved mobile experience

## [2.0.6] - 2021-12-13

### Added
- **Image File Size Tracking**: Added file size tracking for uploaded images
  - Helps monitor storage usage
  - Enables file size optimization workflows

## [2.0.5] - 2021-11-30

### Fixed
- **Meta Keywords**: Fixed typo in keyword meta tag rendering

## [2.0.4] - 2021-11-29

### Fixed
- **Project Dropdown**: Fixed missing project dropdown in admin interface
  - Restored project selection functionality
  - `ProjectComposer` view composer registered for dropdown partial

## [2.0.3] - 2021-11-29

### Added
- **Project Categories**: Complete many-to-many category relationship system
  - `ProjectCategory` model with same trait structure as `Project`
  - `project_categories` table for category data
  - `project_categories_pivot` table for relationships
  - Backend CRUD for managing categories
  - Category-based filtering on frontend
  - Breadcrumb navigation with categories

### Added
- **Duplicate Functionality**: Added ability to duplicate projects
  - `Project::duplicate()` method creates copy with randomized name
  - Copies all relationships (categories, images)
  - New project created with pending status
  - Useful for creating similar projects quickly

### Added
- **Image Management**: Polymorphic image relationship with `Imageable` interface
  - Support for featured, gallery, and WYSIWYG images
  - `HasImages` trait for image CRUD operations
  - Image storage organized by project ID

### Added
- **SEO Features**: Comprehensive SEO support via `HasSeo` trait
  - Meta title, description, keywords fields
  - Canonical URL support
  - Index/noindex control
  - Auto-generated meta descriptions from content

### Added
- **Frontend Builder**: WYSIWYG content builder for projects
  - Authenticated route: `/projects/edit/{uuid}`
  - `BuilderService` for processing images (downloads remote, saves local, updates URLs)
  - Requires `auth` and `employee` middleware
  - Real-time content editing without backend access

### Added
- **Status System**: Three-state status system via `HasStatus` trait
  - Pending, Active, Inactive constants
  - Scopes: `active()`, `inactive()`, `pending()`
  - Frontend displays only active projects

### Added
- **API Endpoints**: RESTful API for projects via Sanctum authentication
  - Route: `/api/projects`
  - `ProjectResource` for JSON transformation
  - Returns active projects with relationships

### Added
- **Event System**: Domain events for project lifecycle
  - `ProjectCreated`, `ProjectUpdated`, `ProjectDeleted` events
  - `SetProjectDate`, `SetProjectUser` listeners (queued)
  - `ClearMenuCache`, `UpdateSitemap` listeners
  - Enables external integrations and cache management

### Added
- **Datatables**: Ajax-powered admin project listing
  - `ProjectDatatableController` for server-side processing
  - Searchable, sortable, paginated results
  - Displays: name, status, category, dates, actions

### Added
- **Soft Deletes**: Projects use soft deletion
  - Recoverable via trash
  - `withTrashed()`, `onlyTrashed()` query support
  - Maintains data integrity for related records

## [2.0.0] - 2021-11-29

### Added
- **Initial Release**: Created project portfolio management package
  - `ProjectServiceProvider` extending `AbstractServiceProvider`
  - `Project` model with comprehensive trait composition
  - Backend CRUD controllers with full validation
  - Frontend display controllers with category filtering
  - Form requests: `StoreProjectRequest`, `UpdateProjectRequest`
  - Complete view structure (backend admin, frontend public)
  - Database migrations for projects table (68 columns including audit fields)
  - Route files: `backend.php`, `frontend.php`, `api.php`
  - Configuration: `project.php` with route prefix settings

### Features
- **Multi-trait Architecture**: Uses 10+ traits for modular functionality
  - `HasContent`, `HasHeaderClass`, `HasImages`, `HasKey`, `HasRelated`
  - `HasSeo`, `HasStatus`, `HasUUID`, `SoftDeletes`

- **Project Fields**:
  - Core: name, slug, key, content, summary, excerpt
  - SEO: meta_title, meta_description, meta_keywords, meta_canonical, meta_index
  - Display: header_transparent, header_sticky, status, date
  - Audit: created_at, updated_at, deleted_at, created_by, updated_by, deleted_by

- **Configuration**:
  - Configurable route prefixes (`prefix`, `category_prefix`)
  - Module namespace: `project`
  - View namespace: `project::`

---

**Package**: `bongo/project`
**Description**: Portfolio project management system with categories, SEO, images, and frontend builder
**Repository**: Internal
**License**: Proprietary
