<?php

use Bongo\Project\Models\ProjectCategory;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectCategoriesTable extends Migration
{
    public function up()
    {
        Schema::create('project_categories', function (Blueprint $table) {

            // Primary
            $table->increments('id');
            $table->uuid('uuid')->index();

            // Fields
            $table->string('name');
            $table->string('key')->nullable()->index();
            $table->string('slug')->index();
            $table->text('content')->nullable();

            $table->enum('status', [
                ProjectCategory::PENDING,
                ProjectCategory::ACTIVE,
                ProjectCategory::INACTIVE,
            ])->default(ProjectCategory::PENDING);

            $table->tinyInteger('transparent_header')->default(ProjectCategory::ENABLED);
            $table->tinyInteger('sticky_header')->default(ProjectCategory::ENABLED);

            // Overrides
            $table->text('css')->nullable();
            $table->text('js')->nullable();

            // SEO Fields
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->enum('meta_index', [
                ProjectCategory::INDEX,
                ProjectCategory::NO_INDEX,
            ])->default(ProjectCategory::INDEX);
            $table->string('meta_canonical')->nullable();

            // Audit
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->unsignedInteger('updated_by')->nullable()->index();
            $table->unsignedInteger('deleted_by')->nullable()->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('project_categories');
    }
}
