# Changelog

All notable changes to `bongo/realgreen` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.6] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` - Cursor IDE guidance with project structure, architecture patterns, event-driven flow, and coding conventions
  - `CLAUDE.md` - Claude Code quick reference with commands, architecture summary, key files, and configuration details
  - `ARCHITECTURE.md` - Detailed architecture with directory structure, class diagrams, data flow diagrams, and extension points
  - `.github/copilot-instructions.md` - GitHub Copilot code templates and common patterns
  - `README.md` - Enhanced user-facing documentation with installation, usage examples, and troubleshooting

## [3.0.5] - 2025-03-24

### Removed
- **LeadFormData**: Removed `formattedAddress` parameter from API payload as requested by RealGreen
  - Removed nested address object containing `houseNumber`, `streetName`, `addressLine2`, `city`, `state`, `zip`, `countryCode`, `latitude`, `longitude`
  - Address fields still sent as flat properties in main payload

## [3.0.4] - 2025-03-13

### Fixed
- **LeadFormData**: Removed call to non-existent `setBranchID()` method that was causing errors

### Changed
- **LeadFormData**: Removed `branchID` property from DTO class

## [3.0.3] - 2025-03-13

### Added
- **LeadFormData**: Added `actionReasonID` field (set to 18) to fix call log notes not appearing in RealGreen
  - Value 18 corresponds to "Note" type in RealGreen system
  - Ensures `callLogNotes` content is properly displayed

### Removed
- **LeadFormData**: Removed unused `branchID` property and setter method

## [3.0.2] - 2025-03-10

### Added
- **Error Tracking**: Added `export_error` field handling to track failed exports
  - `ExportEstimatesToRealGreen` command now stores error messages in `estimate.export_error` field
  - `ExportEstimateToRealGreen` listener captures and stores exception messages
  - Errors are logged but don't prevent estimate updates from completing
  - Enables retry logic for failed exports

### Changed
- **Address Field Fallbacks**: Updated empty address field handling in `LeadFormData`
  - Required address fields (`zipcode`, `streetNumberAndName`, `houseNumber`, `streetName`, `addressLine2`, `city`, `state`, `zip`) now use `'-- --'` as fallback instead of `null`
  - Prevents API validation errors when address fields are not populated

### Fixed
- **LeadForm Service**: Fixed return type annotation from `?string` to `?array` to match actual HTTP response

## [3.0.1] - 2025-03-10

### Changed
- **Phone Number Handling**: Updated `cellPhoneNumber` field in `LeadFormData`
  - Now accepts all phone numbers (removed 07 prefix requirement)
  - Previously only sent mobile numbers starting with 07

### Removed
- **LeadFormData**: Removed `homePhoneNumber` field from API payload as requested by RealGreen
- **Export Condition**: Removed `exported_at` check from `ExportEstimateToRealGreen` listener
  - Estimates now re-export on every update instead of only on first export
  - Allows RealGreen to receive estimate modifications

### Added
- **Schema Documentation**: Added `src/Schema/lead_form.json` with example API payload structure
- **Return Types**: Added explicit return type `?string` to `LeadForm::export()` method

### Fixed
- **API Response**: `LeadForm::export()` now returns HTTP response instead of discarding it
- **Spelling**: Changed "installments" to "instalments" in call log notes (British English)

## [3.0.0] - 2025-03-10

### Removed
- **Strict Types**: Removed `declare(strict_types=1)` from all PHP files for v2.0 compatibility
  - Removed from `ExportEstimatesToRealGreen` command
  - Removed from `realgreen.php` config file
  - Removed from `ExportEstimateToRealGreen` listener
  - Removed from `RealGreenServiceProvider`
  - Removed from `LeadForm` service
  - Removed from `SourceCode` service

### Changed
- **Service Provider**: Updated property type declarations for PHP 7.4 compatibility
  - Changed `protected string $module` to `protected $module`
  - Changed `protected array $commands` to `protected $commands`
  - Changed `protected array $listeners` to `protected $listeners`

## [2.0.8] - 2025-03-10

### Changed
- **Composer Dependencies**: Updated for v2.0 compatibility with older Laravel/PHP versions
  - `illuminate/support`: `~5.8.0|^6.0|^7.0`
  - `php`: `>=7.4`
  - `bongo/framework`: `^2.0`
  - Removed Laravel Pint, Larastan, Orchestra Testbench, PHPStan dependencies
  - Removed all composer scripts (analyse, test, test-coverage, format)

## [2.0.7] - 2025-03-03

### Added
- **Initial RealGreen Integration**: Created complete API integration for exporting estimates to RealGreen CRM
  - `ExportEstimatesToRealGreen` command for batch exporting estimates via CLI
  - `ExportEstimateToRealGreen` listener for automatic export on `EstimateUpdated` event
  - `LeadForm` service for submitting estimates to RealGreen `/LeadForm/Submit` API endpoint
  - `SourceCode` service for retrieving marketing source codes from RealGreen API
  - `LeadFormData` DTO for transforming Bongo estimates to RealGreen lead form format
  - `PackageSeeder` for registering package in database
  - `realgreen.php` config file with API URL and default source code (28 - GOO/Google)

### Features
- **Command**: `php artisan realgreen:export_estimates` with `--all` flag for re-exporting previously exported estimates
- **Event-Driven Export**: Automatic export when estimate is updated (production only, non-draft status, not previously exported)
- **Field Mapping**: Complete mapping of Bongo estimate fields to RealGreen lead form structure
  - Customer details: name, email, phone (separate home/cell based on 07 prefix)
  - Address: full UK address with postcode, coordinates
  - Marketing: source code 28 (Google)
  - Notes: formatted estimate details including areas, pricing, payment terms
  - Employee: fixed to "JCHAPMAN"
  - Branch: set to 0

### Technical
- **Error Handling**: Silent failure pattern - exceptions logged but don't block estimate updates
- **Production Guard**: Exports only occur in production environment with valid API key
- **SSL**: HTTP client configured with `withoutVerifying()` for staging environments
- **API Authentication**: Uses `apiKey` header with value from system settings
- **Timestamp Tracking**: Updates `estimate.exported_at` on successful export

## [2.0.0] - 2025-03-03

### Added
- **Package Structure**: Initial package scaffolding created
  - Service provider: `RealGreenServiceProvider`
  - Configuration: `.editorconfig`, `.php_cs`, `.styleci.yml`, `pint.json`
  - Testing: `phpunit.xml.dist`, `phpstan.neon.dist`, `tests/TestCase.php`
  - Documentation: `LICENSE`, `README.md`
  - Composer: `composer.json` with package metadata and dependencies
  - IDE Support: `ide.json`, `auth.json`

---

**Package**: `bongo/realgreen`
**Repository**: Internal
**License**: Proprietary
