<?php

declare(strict_types=1);

namespace Bongo\RealGreen\Listeners;

use Bongo\Estimate\Models\Estimate;
use Bongo\RealGreen\Services\LeadForm;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Http\Client\RequestException;

class ExportEstimateToRealGreen
{
    /** @throws BindingResolutionException */
    public function handle($event): void
    {
        if (app()->isProduction()
            && ! empty(setting('system::credentials.real_green_api_key'))
            && $event->estimate
            && $event->estimate->status !== Estimate::DRAFT
        ) {
            try {
                (new LeadForm())->export($event->estimate);
                $event->estimate->exported_at = now();
                $event->estimate->export_error = null;
                $event->estimate->save();

            } catch (RequestException|BindingResolutionException $e) {
                $event->estimate->export_error = $e->getMessage();
                $event->estimate->save();

                log_exception($e);
                console_print($e->getMessage());
            }
        }
    }
}
