<?php

declare(strict_types=1);

namespace Bongo\RealGreen;

use Bongo\Estimate\Events\EstimateUpdated;
use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\RealGreen\Commands\ExportEstimatesToRealGreen;
use Bongo\RealGreen\Listeners\ExportEstimateToRealGreen;

class RealGreenServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'realgreen';

    protected array $commands = [
        ExportEstimatesToRealGreen::class,
    ];

    protected array $listeners = [
        EstimateUpdated::class => [
            ExportEstimateToRealGreen::class,
        ],
    ];
}
