<?php

declare(strict_types=1);

namespace Bongo\RealGreen\Services;

use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Http;

class SourceCode
{
    /** @throws RequestException|BindingResolutionException */
    public function all(): Collection
    {
        return Http::withoutVerifying()
            ->baseUrl(config('realgreen.api_url'))
            ->withHeaders(['apiKey' => setting('system::credentials.real_green_api_key')])
            ->get('/SourceCode')
            ->throw()
            ->collect();
    }

    /** @throws RequestException|BindingResolutionException */
    public function byAbbreviation(string $abbreviation): ?array
    {
        return $this->all()->firstWhere('sourceAbbreviation', $abbreviation);
    }
}
