<?php

declare(strict_types=1);

namespace Bongo\RealGreen\Services;

use Bongo\Estimate\Models\Estimate;
use Bongo\RealGreen\Data\LeadFormData;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Http\Client\RequestException;
use Illuminate\Support\Facades\Http;

class LeadForm
{
    /** @throws RequestException|BindingResolutionException */
    public function export(Estimate $estimate): ?array
    {
        $leadFormData = (new LeadFormData())
            ->fromModel($estimate)
            ->toArray();

        return Http::withoutVerifying()
            ->baseUrl(config('realgreen.api_url'))
            ->withHeaders(['apiKey' => setting('system::credentials.real_green_api_key')])
            ->post('/LeadForm/Submit', $leadFormData)
            ->throw()
            ->json();
    }
}
