<?php

namespace Bongo\Redirect\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Bongo\Redirect\Models\Redirect;
use Illuminate\Database\Eloquent\Builder;

class RedirectDatatableController extends AbstractDatatableController
{
    protected Redirect $redirect;

    public function __construct(Redirect $redirect)
    {
        $this->redirect = $redirect;
    }

    protected function applyOrderBy()
    {
        $this->query
            ->orderBy('from', 'asc')
            ->orderBy('to', 'asc');
    }

    protected function getBaseQuery(): Builder
    {
        return $this->redirect->newQuery();
    }
}
