<?php

namespace Bongo\Redirect\Http\Middleware;

use Bongo\Framework\Helpers\URL;
use Closure;
use Illuminate\Http\Request;

class RemoveWWW
{
    public function handle(Request $request, Closure $next)
    {
        if (URL::hasWWW($request)) {
            $request->headers->set('host', URL::withoutWWW($request));

            return redirect()->away($request->fullUrl(), 301);
        }

        return $next($request);
    }
}
