<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRedirectsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('redirects')) {
            Schema::create('redirects', function (Blueprint $table) {

                // Primary
                $table->increments('id');

                // Fields
                $table->string('from')->index();
                $table->string('to')->index();

                // Timestamps
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('redirects');
    }
}
