@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        Redirect ID: {{ $redirect->id }}
        @slot('actions')
            @deleteButton(['name' => trans('redirect::backend.delete'), 'url' => route('backend.redirect.destroy', $redirect->id)])
            @backButton(['name' => trans('redirect::backend.index'), 'url' => route('backend.redirect.index')])
            @editButton(['name' => trans('redirect::backend.edit'), 'url' => route('backend.redirect.edit', $redirect->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6">
            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    @static(['name' => 'From', 'value' => $redirect->from])
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    @static(['name' => 'To', 'value' => $redirect->to])
                @endcomponent
            </div>
        </section>
    @endcomponent
@stop
