<?php

namespace Bongo\Redirect\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Redirect\Events\RedirectCreated;
use Bongo\Redirect\Events\RedirectUpdated;
use Bongo\Redirect\Http\Requests\StoreRedirectRequest;
use Bongo\Redirect\Http\Requests\UpdateRedirectRequest;
use Bongo\Redirect\Models\Redirect;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

class RedirectController extends AbstractController
{
    protected Redirect $redirect;

    public function __construct(Redirect $redirect)
    {
        $this->redirect = $redirect;
    }

    public function index(): View
    {
        return view('redirect::backend.index');
    }

    public function create(): View
    {
        $redirect = $this->redirect;

        return view('redirect::backend.create', compact('redirect'));
    }

    public function store(StoreRedirectRequest $request): RedirectResponse
    {
        $redirect = $this->redirect->create($request->all());
        event(new RedirectCreated($redirect));

        return redirect()
            ->route('backend.redirect.show', $redirect->id)
            ->success(trans('redirect::backend.store_success'));
    }

    public function show(Redirect $redirect): View
    {
        return view('redirect::backend.show', compact('redirect'));
    }

    public function edit(Redirect $redirect): View
    {
        return view('redirect::backend.edit', compact('redirect'));
    }

    public function update(UpdateRedirectRequest $request, Redirect $redirect): RedirectResponse
    {
        $redirect->update($request->all());
        event(new RedirectUpdated($redirect));

        return redirect()
            ->route('backend.redirect.show', $redirect->id)
            ->success(trans('redirect::backend.update_success'));
    }

    public function destroy(Redirect $redirect)
    {
        if ($redirect->delete()) {
            Cache::forget('redirects');

            return redirect()
                ->route('backend.redirect.index')
                ->success(trans('redirect::backend.delete_success'));
        }

        return back()->error(trans('redirect::backend.delete_failed'));
    }
}
