<?php

namespace Bongo\Redirect\Http\Middleware;

use Bongo\Framework\Helpers\URL;
use Closure;
use Illuminate\Http\Request;

class RemoveSlash
{
    public function handle(Request $request, Closure $next)
    {
        // If this is a get request and does not have a query string and is missing a slash
        if ($request->isMethod('get')
            && ! URL::isHomePage($request)
            && ! URL::isAFile($request)
            && ! URL::hasQueryString($request)
            && URL::endsWithSlash($request)
        ) {
            $path = rtrim($request->getPathInfo(), '/');

            return redirect()->to($request->getUriForPath($path), 301);
        }

        return $next($request);
    }
}
