<?php

namespace Bongo\Redirect\Models;

use Bongo\Framework\Models\AbstractModel;

class Redirect extends AbstractModel
{
    /** @var array */
    protected $fillable = [
        'from',
        'to',
    ];

    public function setFromAttribute($value)
    {
        if (! empty($value)) {
            $this->attributes['from'] = '/'.ltrim($value, '/');
        }
    }

    public function setToAttribute($value)
    {
        if (! empty($value)) {
            $this->attributes['to'] = '/'.ltrim(strtolower($value), '/');
        }
    }
}
