<?php

namespace Bongo\Redirect;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Redirect\Events\RedirectCreated;
use Bongo\Redirect\Events\RedirectUpdated;
use Bongo\Redirect\Http\Middleware\HasRedirects;
use Bongo\Redirect\Http\Middleware\RemoveSlash;
use Bongo\Redirect\Http\Middleware\RemoveWWW;
use Bongo\Redirect\Listeners\ClearRedirectCache;

class RedirectServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'redirect';

    protected array $listeners = [
        RedirectCreated::class => [
            ClearRedirectCache::class,
        ],
        RedirectUpdated::class => [
            ClearRedirectCache::class,
        ],
    ];

    protected array $middlewares = [
        'removeWWW' => RemoveWWW::class,
        'removeSlash' => RemoveSlash::class,
        'hasRedirects' => HasRedirects::class,
    ];

    public function boot(): void
    {
        parent::boot();

        $this->app['router']->pushMiddlewareToGroup('web', RemoveWWW::class);
        $this->app['router']->pushMiddlewareToGroup('web', RemoveSlash::class);
    }
}
