<?php

use Bongo\Redirect\Http\Controllers\Backend\RedirectController;
use Bongo\Redirect\Http\Controllers\Backend\RedirectDatatableController;
use Illuminate\Support\Facades\Route;

Route::as('redirect.')
    ->middleware('developer')
    ->prefix(config('redirect.prefix'))
    ->group(function () {

        Route::get('/', [RedirectController::class, 'index'])
            ->name('index');

        Route::get('create', [RedirectController::class, 'create'])
            ->name('create');

        Route::post('store', [RedirectController::class, 'store'])
            ->name('store');

        Route::get('datatable', [RedirectDatatableController::class, 'index'])
            ->name('datatable');

        // Redirect/{redirect}/
        Route::prefix('{redirect}')
            ->group(function () {

                Route::get('/', [RedirectController::class, 'show'])
                    ->name('show');

                Route::get('edit', [RedirectController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [RedirectController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [RedirectController::class, 'destroy'])
                    ->name('destroy');
            });
    });
