<?php

declare(strict_types = 1);

namespace Bongo\Referrer\Http\Middleware;

use Bongo\Referrer\Services\Referrer;
use Closure;

class CaptureReferrer
{
    protected Referrer $referrer;

    public function __construct(Referrer $referrer)
    {
        $this->referrer = $referrer;
    }

    public function handle($request, Closure $next)
    {
        $this->referrer->putFromRequest($request);

        return $next($request);
    }
}
