<?php

namespace Bongo\Review\Commands;

use Bongo\Review\Exports\ReviewExport;
use Bongo\Review\Models\Review;
use Illuminate\Console\Command;
use Maatwebsite\Excel\Facades\Excel;

class ExportReviewsCommand extends Command
{
    /** @var string */
    protected $signature = 'review:export';

    /** @var string */
    protected $description = 'Exports the reviews to a csv file.';

    public function handle(): void
    {
        console_print('Exporting reviews to a csv file...');

        $rows = Review::all();

        Excel::store(new ReviewExport($rows), 'reviews.csv');

        console_print('Reviews exported to '. storage_path('reviews.csv'));
    }
}
