<?php

use Bongo\Review\Models\Review;
use Bongo\Review\Seeders\PackageSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

class CreateReviewsTable extends Migration
{
    public function up()
    {
        Schema::create(Str::plural('review'), function (Blueprint $table) {

            // Primary
            $table->increments('id');
            $table->uuid('uuid')->index();

            // Fields
            $table->string('name');
            $table->text('content')->nullable();
            $table->unsignedTinyInteger('rating')->default(5)->index();
            $table->enum('status', [Review::PENDING, Review::ACTIVE, Review::INACTIVE])->default(Review::PENDING);

            // Audit
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->unsignedInteger('updated_by')->nullable()->index();
            $table->unsignedInteger('deleted_by')->nullable()->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });

        // If the package table exists then seed the package
        if (Schema::hasTable('packages')) {
            Artisan::call('db:seed', ['--class' => PackageSeeder::class, '--force' => true]);
        }
    }

    public function down()
    {
        Schema::dropIfExists(Str::plural('review'));
    }
}
