@extends('framework::frontend.layouts.app')

@section('body_class', 'review-page')
@section('breadcrumb', Str::limit($review->name, 30))
@section('page_title', Str::limit($review->name, 30))
@section('meta_title', $review->name . ' - ' . Str::limit($review->title, 30))
@section('meta_description', $review->summary)

@section('content')
    <div class="container py-5">
        <div class="row">

            <div class="col-lg-4 order-lg-2">
                <aside class="sticky-lg-top">
                    @include('review::frontend.partials.summary')
                    @include('review::frontend.partials.form')
                </aside>
            </div>

            <div class="col-lg-8 order-lg-1">

                <section class="review">
                    <div class="row align-items-center mb-5">
                        <div class="col">
                            <div class="review-name">
                                {{ $review->name }}
                            </div>
                            @if(!empty($review->date))
                                <div class="review-date">
                                    {{ $review->date->format('jS F Y') }}
                                </div>
                            @endif
                        </div>
                        <div class="col">
                            <div class="rating-stars text-right">
                                <span class="fa fa-star {{ $review->rating >= 1 ? 'checked' : '' }}"></span>
                                <span class="fa fa-star {{ $review->rating >= 2 ? 'checked' : '' }}"></span>
                                <span class="fa fa-star {{ $review->rating >= 3 ? 'checked' : '' }}"></span>
                                <span class="fa fa-star {{ $review->rating >= 4 ? 'checked' : '' }}"></span>
                                <span class="fa fa-star {{ $review->rating >= 5 ? 'checked' : '' }}"></span>
                            </div>
                        </div>
                    </div>

                    <h2 class="review-title mb-4">
                        {{ $review->title }}
                    </h2>

                    <p class="review-content">
                        {{ $review->content }}
                    </p>
                </section>

                <section class="review-meta mt-5">
                    <div class="row align-items-center mb-4">
                        <div class="col">
                            <a href="{{ route('frontend.review.index') }}">
                                Back To Reviews
                            </a>
                        </div>
                    </div>
                </section>
            </div>

        </div>
    </div>
@stop
