<?php

namespace Bongo\Review\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreFrontendReviewRequest extends FormRequest
{
    public function rules(): array
    {
        $recaptchaEnabled = setting()->reCaptchaEnabled() && config('review.recaptcha.enabled');
        $recaptchaMinScore = config('review.recaptcha.min_score', 0.5);

        return [
            'title' => 'required',
            'content' => 'required',
            'rating' => 'required',
            'name' => 'required',
            'email' => 'required|string|email:rfc,dns|max:50',

            'g-recaptcha-response' => [
                "recaptchav3:review,{$recaptchaMinScore},",
                Rule::requiredIf(fn () => $recaptchaEnabled),
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'g-recaptcha-response' => [
                'recaptchav3' => 'reCAPTCHA validation failed, please try again or contact us for more assistance',
            ],
        ];
    }
}
