<?php

namespace Bongo\Review\Http\ViewComposers;

use Bongo\Review\Models\Review;
use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

class LatestReviewComposer
{
    public function compose(View $view): void
    {
        // $view_data = $view->getData();

        // Get the most recent review
        $latestReview = Cache::remember('latest_review', config('settings.cache_default'), function () {
            return Review::active()->whereNotNull('date')->latest('date')->first();
        });

        // Pass the data to the view partial
        $view->with(compact('latestReview'));
    }
}
