<?php

namespace Bongo\Review\Http\ViewComposers;

use Bongo\Review\Models\Review;
use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

class NumberOfReviewsComposer
{
    public function compose(View $view): void
    {
        // $view_data = $view->getData();

        // Get the total number of reviews
        $noOfReviews = Cache::remember('no_of_reviews', config('settings.cache_default'), function () {
            return Review::active()->count();
        });

        // Pass the data to the view partial
        $view->with(compact('noOfReviews'));
    }
}
