<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTitleColumnToReviewsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('reviews', 'title')) {
            Schema::table('reviews', function (Blueprint $table) {
                $table->string('title')->nullable()->after('uuid');
            });
        }
    }

    public function down()
    {
        Schema::table('reviews', function (Blueprint $table) {
            $table->dropColumn('title');
        });
    }
}
