<?php

namespace Bongo\Review\Models;

use Bongo\Framework\Casts\Date;
use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasContent;
use Bongo\Framework\Traits\HasStatus;
use Bongo\Framework\Traits\HasUUID;
use Illuminate\Database\Eloquent\SoftDeletes;

class Review extends AbstractModel
{
    public const PENDING = 'pending';
    public const ACTIVE = 'active';
    public const INACTIVE = 'inactive';

    use HasContent;
    use HasStatus;
    use HasUUID;
    use SoftDeletes;

    protected $casts = [
        'date' => Date::class,
    ];

    protected $fillable = [
        'date',
        'title',
        'content',
        'rating',
        'status',
        'name',
        'email',
    ];
}
