<?php

use Bongo\Review\Http\Controllers\Backend\ReviewController;
use Bongo\Review\Http\Controllers\Backend\ReviewDatatableController;
use Illuminate\Support\Facades\Route;

Route::as('review.')
    ->prefix(config('review.prefix'))
    ->group(function () {

        Route::get('/', [ReviewController::class, 'index'])
            ->name('index');

        Route::get('create', [ReviewController::class, 'create'])
            ->name('create');

        Route::post('store', [ReviewController::class, 'store'])
            ->name('store');

        Route::get('datatable', [ReviewDatatableController::class, 'index'])
            ->name('datatable');

        // Review/{review}/
        Route::prefix('{review}')
            ->group(function () {

                Route::get('/', [ReviewController::class, 'show'])
                    ->name('show');

                Route::get('edit', [ReviewController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [ReviewController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [ReviewController::class, 'destroy'])
                    ->name('destroy');
            });
    });
