@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ trans('review::backend.index') }}
        @slot('actions')
            @backButton(['name' => trans('dashboard::backend.index')])
            @createButton(['name' => trans('review::backend.create'), 'url' => route('backend.review.create')])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <data-table
            search-url="{{ route('backend.review.datatable') }}"
            resource-url="{{ route('backend.review.index') }}"
            order-by="date"
            order-direction="desc"
            v-cloak
        >
            <template slot="custom-filters" slot-scope="{updateFilters, getFilterValue}">
                <data-table-filter :first-child="true">
                    <select class="form-input w-full block rounded-sm pr-10 sm:text-sm sm:leading-5"
                            :value="getFilterValue('status')"
                            @change="event => updateFilters(event, 'status')"
                    >
                        <option value="">All Statuses</option>
                        <option value="pending">Pending</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                        <svg class="fill-current h-4 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                            <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/>
                        </svg>
                    </div>
                </data-table-filter>
            </template>

            <template slot="default" slot-scope="{items, itemIndex, isSelected, setAsSelectedItem, viewUrl, editUrl}">
                <div class="grid md:grid-cols-2 gap-3">

                    <v-card
                        v-for="(item, index) in items"
                        :key="item.id"
                        :id="itemIndex(item, index)"
                        :class="['col-span-1', { selected : isSelected(item, index) }]"
                        @click="setAsSelectedItem(item, index)"
                    >
                        <template slot="left">
                            <a :href="viewUrl(item)" title="View"
                               class="block font-semibold hover:text-primary-500 focus:text-primary-600 flex items-center"
                            >
                                @{{ item.title }}
                            </a>
                            <div class="text-xs mt-3">
                                <span :class="[item.status === 'active' ? 'text-green-400' : 'text-red-500']">
                                    @{{ item.status | ucwords }}
                                </span>
                                &nbsp;|&nbsp;
                                <span class="text-yellow-700">
                                    @{{ item.rating }} Star
                                </span>
                                &nbsp;|&nbsp;
                                <span class="text-gray-500">
                                    @{{ item.name }}
                                </span>
                                &nbsp;|&nbsp;
                                <span v-if="item.date" class="text-gray-500">
                                    @{{ item.date | date }}
                                </span>
                            </div>
                        </template>

                        <template slot="right">
                            <v-button :link="viewUrl(item)">View</v-button>
                        </template>
                    </v-card>

                </div>
            </template>
        </data-table>
    @endcomponent
@stop
