<section class="md:grid md:grid-cols-2 md:gap-6">
    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4">
                <div class="sm:col-span-1">
                    @input(['name' => 'title', 'value' => $review->title, 'placeholder' => 'Thank you so much!',
                    'required' => 'true'])
                </div>
                <div class="sm:col-span-1">
                    @textarea([
                    'name' => 'content',
                    'value' => $review->content,
                    'placeholder' => 'Great communication from Neil understanding what I required. Will definitely be
                    recommending Designtec.',
                    'required' => 'true'
                    ])
                </div>
            </div>
        @endcomponent
    </div>

    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                <div class="sm:col-span-2">
                    <label for="date" class="text-sm leading-5 font-medium text-gray-500">Date</label>
                    <v-datepicker
                        name="date"
                        value="{{ !empty($review->date) ? old('date', $review->date->format('d/m/Y')) : null }}"
                    ></v-datepicker>
                </div>
                <div class="sm:col-span-1">
                    @select([
                    'name' => 'status',
                    'value' => $review->status,
                    'options' => get_enum_values('reviews', 'status'),
                    'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @select([
                    'name' => 'rating',
                    'value' => $review->rating,
                    'options' => [1 => '1 Star', 2 => '2 Star', 3 => '3 Star', 4 => '4 Star', 5 => '5 Star'],
                    'required' => 'true'
                    ])
                </div>
                <div class="sm:col-span-1">
                    @input(['label' => 'Full Name', 'name' => 'name', 'value' => $review->name, 'placeholder' => 'John
                    Smith', 'required' => 'true'])
                </div>
                <div class="sm:col-span-1">
                    @input(['name' => 'email', 'value' => $review->email, 'placeholder' => 'john.smith@test.com'])
                </div>
            </div>
        @endcomponent
    </div>

</section>
