<div class="card mb-4">
    <div class="card-body">
        <h3 class="mb-3">Leave A Review</h3>

        <form action="{{ route('frontend.review.store') }}" method="POST">
            <div class="validation">
                {{ csrf_field() }}
                @honeypot
                @if(setting()->reCaptchaEnabled())
                    {!! RecaptchaV3::field('review') !!}
                @endif
            </div>

            <div class="form-group">
                <input class="form-control"
                       name="title"
                       type="text"
                       maxlength="100"
                       value="{{ old('title') }}"
                       data-msg-required="Please enter your opinion."
                       placeholder="Your opinion in one sentence..."
                       required
                >
            </div>

            <div class="form-group">
                <textarea class="form-control"
                          name="content"
                          maxlength="5000"
                          data-msg-required="Please enter your review."
                          placeholder="Your full review..."
                          required
                >{{ old('content') }}</textarea>
            </div>

            <div class="form-group">
                <select class="form-control" name="rating" required>
                    <option value="1">1 Star</option>
                    <option value="2">2 Star</option>
                    <option value="3">3 Star</option>
                    <option value="4">4 Star</option>
                    <option value="5" selected="selected">5 Star</option>
                </select>
            </div>

            <div class="form-group">
                <input class="form-control"
                       name="name"
                       type="text"
                       maxlength="100"
                       value="{{ old('name') }}"
                       data-msg-required="Please enter your full name."
                       placeholder="Your Name..."
                       required
                >
            </div>

            <div class="form-group">
                <input class="form-control"
                       name="email"
                       type="email"
                       maxlength="100"
                       value="{{ old('email') }}"
                       data-msg-required="Please enter your email address."
                       data-msg-email="Please enter a valid email address."
                       placeholder="Your Email Address..."
                       required
                >
            </div>

            <div class="form-group text-right">
                <button class="form-submit btn btn-primary font-weight-bold text-uppercase"
                        type="submit"
                >
                    Submit
                </button>
            </div>
        </form>

    </div>
</div>
