<?php

namespace Bongo\Review\Http\Requests;

use Bongo\Captcha\Rules\Captcha;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreFrontendReviewRequest extends FormRequest
{
    public function rules(): array
    {
        $recaptchaEnabled = setting()->reCaptchaEnabled() && config('review.recaptcha.enabled');
        $recaptchaMinScore = config('review.recaptcha.min_score', 0.5);

        return [
            'title' => 'required',
            'content' => 'required',
            'rating' => 'required',
            'name' => 'required',
            'email' => 'required|string|email:rfc,dns|max:50',

            'captcha-response' => new Captcha(
                action: 'review',
                minScore: $recaptchaMinScore,
                enabled: $recaptchaEnabled,
            ),
        ];
    }
}
