<?php

namespace Bongo\Review\Http\ViewComposers;

use Bongo\Review\Models\Review;
use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

class AverageRatingComposer
{
    public function compose(View $view): void
    {
        // $view_data = $view->getData();

        // Get the average rating of all active reviews
        $averageRating = Cache::remember('average_rating', config('settings.cache_default'), function () {
            return ceil(Review::active()->average('rating'));
        });

        // Get the corresponding text version of the active reviews
        if ($averageRating >= 5) {
            $averageRatingText = 'Excellent';
        } elseif ($averageRating >= 4) {
            $averageRatingText = 'Great';
        } elseif ($averageRating >= 3) {
            $averageRatingText = 'Average';
        } elseif ($averageRating >= 2) {
            $averageRatingText = 'Poor';
        } else {
            $averageRatingText = 'Bad';
        }

        // Pass the data to the view partial
        $view->with(compact('averageRating', 'averageRatingText'));
    }
}
