<?php

namespace Bongo\Review\Mailables;

use Bongo\Review\Models\Review;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Mail\Mailable;

class ReviewMailable extends Mailable
{
    protected Review $review;

    public function __construct(Review $review)
    {
        $this->review = $review;
    }

    /**
     * @throws BindingResolutionException
     */
    public function build(): ReviewMailable
    {
        return $this
            ->from(
                config("settings.mail_from_address"),
                config("settings.mail_from_name")
            )
            ->replyTo(
                setting("client::company.email"),
                setting("client::company.name"),
            )
            ->subject('Thank you for your review')
            ->view('review::mail.review', [
                'review' => $this->review,
            ])
            ->text('review::mail.review_plain', [
                'review' => $this->review,
            ]);
    }
}
