<?php

use Bongo\Review\Http\Controllers\Frontend\ReviewController;
use Illuminate\Support\Facades\Route;
use Spatie\Honeypot\ProtectAgainstSpam;

Route::prefix(config('review.prefix'))
    ->as('review.')
    ->group(function () {

        Route::get('/', [ReviewController::class, 'index'])
            ->name('index');

        Route::get('{uuid}', [ReviewController::class, 'show'])
            ->name('show');

        Route::post('store', [ReviewController::class, 'store'])
            ->middleware(ProtectAgainstSpam::class)
            ->name('store');
    });
