<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddEmailColumnToReviewsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('reviews', 'email')) {
            Schema::table('reviews', function (Blueprint $table) {
                $table->string('email')->nullable()->after('name');
            });
        }
    }

    public function down()
    {
        Schema::table('reviews', function (Blueprint $table) {
            $table->dropColumn('email');
        });
    }
}
