<?php

namespace Bongo\Review;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Review\Commands\ExportReviewsCommand;
use Bongo\Review\Events\ReviewCreated;
use Bongo\Review\Events\ReviewUpdated;
use Bongo\Review\Http\ViewComposers\AverageRatingComposer;
use Bongo\Review\Http\ViewComposers\LatestReviewComposer;
use Bongo\Review\Http\ViewComposers\NumberOfReviewsComposer;
use Bongo\Review\Listeners\ClearReviewCache;
use Bongo\Sitemap\Listeners\UpdateSitemap;

class ReviewServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'review';

    protected array $commands = [
        ExportReviewsCommand::class,
    ];

    protected array $composers = [
        NumberOfReviewsComposer::class => [
            'review::frontend.partials.summary',
        ],
        LatestReviewComposer::class => [
            'review::frontend.partials.summary',
        ],
        AverageRatingComposer::class => [
            'review::frontend.partials.summary',
        ],
    ];

    protected array $listeners = [
        ReviewCreated::class => [
            ClearReviewCache::class,
        ],
        ReviewUpdated::class => [
            ClearReviewCache::class,
            UpdateSitemap::class,
        ],
    ];
}
