@extends('framework::mail.layouts.app')

@php
    $cellStyle = 'padding-top: 10px; padding-right: 0; padding-bottom: 10px; padding-left: 0; border:0';
@endphp

@section('content')

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        <h1 style="margin-top:0; margin-bottom:20px; font-size:26px; line-height:32px; font-weight:bold; letter-spacing:-0.02em;">
            Thank you for you review
        </h1>
        <p style="margin-top: 0;">Status: Pending</p>
    @endcomponent

    @component('framework::mail.layouts.partials.section')
        <table width="100%" cellpadding="0" border="0" cellspacing="0">

            @if(!empty($review->title))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Your Opinion</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $review->title }}
                    </td>
                </tr>
            @endif

            @if(!empty($review->rating))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Your Rating</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $review->rating }} star
                    </td>
                </tr>
            @endif

            @if(!empty($review->content))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Your Review</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $review->content }}
                    </td>
                </tr>
            @endif

            @if(!empty($review->name))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Your Name</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $review->name }}
                    </td>
                </tr>
            @endif

            @if(!empty($review->email))
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>Your Email</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        {{ $review->email }}
                    </td>
                </tr>
            @endif

        </table>
    @endcomponent

@stop
