<?php

namespace Bongo\Review\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Bongo\Review\Models\Review;
use Illuminate\Database\Eloquent\Builder;

/**
 * Class ReviewDatatableController.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Review\Http\Controllers\Backend
 */
class ReviewDatatableController extends AbstractDatatableController
{
    /**
     * @var Review
     */
    protected $review;

    /**
     * ReviewDatatableController constructor.
     *
     * @param Review $review
     */
    public function __construct(Review $review)
    {
        $this->review = $review;
    }

    /**
     * Get base query.
     *
     * @return Builder
     */
    protected function getBaseQuery(): Builder
    {
        return $this->review->newQuery();
    }
}
