<?php

namespace Bongo\Review\Http\Requests;

use Bongo\Review\Models\Review;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class StoreReviewRequest.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Review\Http\Requests
 */
class StoreReviewRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        //$reviewTable = (new Review())->getTable();

        return [
            'title'   => 'required',
            'content' => 'required',
            'rating'  => 'required',
            'name'    => 'required',
            'email'   => 'required|string|email:rfc,dns|max:50'
        ];
    }
}
