<?php

namespace Bongo\Review\Http\ViewComposers;

use Bongo\Review\Models\Review;
use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

/**
 * Class AverageRatingComposer.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Review\Http\ViewComposers
 */
class AverageRatingComposer
{
    /**
     * Bind data to the view.
     *
     * @param View $view
     *
     * @return void
     */
    public function compose(View $view)
    {
        // $view_data = $view->getData();

        // Get the average rating of all active reviews
        $averageRating = Cache::remember('average_rating', config('settings.cache_default'), function () {
            return ceil(Review::active()->average('rating'));
        });

        // Get the corresponding text version of the active reviews
        if ($averageRating >= 5) {
            $averageRatingText = 'Excellent';
        } elseif ($averageRating >= 4) {
            $averageRatingText = 'Great';
        } elseif ($averageRating >= 3) {
            $averageRatingText = 'Average';
        } elseif ($averageRating >= 2) {
            $averageRatingText = 'Poor';
        } else {
            $averageRatingText = 'Bad';
        }

        // Pass the data to the view partial
        $view->with(compact('averageRating', 'averageRatingText'));
    }
}
