<?php

namespace Bongo\Review\Http\ViewComposers;

use Bongo\Review\Models\Review;
use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

/**
 * Class LatestReviewComposer.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Review\Http\ViewComposers
 */
class LatestReviewComposer
{
    /**
     * @param View $view
     *
     * @return void
     */
    public function compose(View $view)
    {
        // $view_data = $view->getData();

        // Get the most recent review
        $latestReview = Cache::remember('latest_review', config('settings.cache_default'), function () {
            return Review::active()->whereNotNull('date')->latest('date')->first();
        });

        // Pass the data to the view partial
        $view->with(compact('latestReview'));
    }
}
