<?php

namespace Bongo\Review\Http\ViewComposers;

use Bongo\Review\Models\Review;

use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

/**
 * Class NumberOfReviewsComposer.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Review\Http\ViewComposers
 */
class NumberOfReviewsComposer
{
    /**
     * Bind data to the view.
     *
     * @param View $view
     *
     * @return void
     */
    public function compose(View $view)
    {
        // $view_data = $view->getData();

        // Get the total number of reviews
        $noOfReviews = Cache::remember('no_of_reviews', config('settings.cache_default'), function () {
            return Review::active()->count();
        });

        // Pass the data to the view partial
        $view->with(compact('noOfReviews'));
    }
}
