<?php

namespace Bongo\Review\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Cache;

/**
 * Class ClearReviewCache
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Review\Listeners
 */
class ClearReviewCache implements ShouldQueue
{
    /**
     * Maximum tries
     *
     * @var int
     */
    public $tries = 3;

    /**
     * @param $event
     */
    public function handle($event): void
    {
        Cache::forget('no_of_reviews');
        Cache::forget('latest_review');
        Cache::forget('average_rating');
    }
}
