<?php

namespace Bongo\Review\Mailables;

use Bongo\Review\Models\Review;
use Illuminate\Mail\Mailable;

class AdminReviewMailable extends Mailable
{
    /** @var Review */
    protected $review;

    public function __construct(Review $review)
    {
        $this->review = $review;
    }

    public function build(): AdminReviewMailable
    {
        return $this
            ->from(
                config("settings.mail_from_address"),
                config("settings.mail_from_name")
            )
            ->replyTo(
                $this->review->email,
                $this->review->name,
            )
            ->subject('New review from: '. $this->review->email)
            ->view('review::mail.admin_review', [
                'review' => $this->review,
            ])
            ->text('review::mail.admin_review_plain', [
                'review' => $this->review,
            ]);
    }
}
