<?php

use Bongo\Review\Models\Review;
use Bongo\Review\Seeders\PackageSeeder;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;

/**
 * Class CreateReviewsTable.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
class CreateReviewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(Str::plural('review'), function (Blueprint $table) {

            // Primary
            $table->increments('id');
            $table->uuid('uuid')->index();

            // Fields
            $table->string('name');
            $table->text('content')->nullable();
            $table->unsignedTinyInteger('rating')->default(5)->index();
            $table->enum('status', [Review::PENDING, Review::ACTIVE, Review::INACTIVE])->default(Review::PENDING);

            // Audit
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->unsignedInteger('updated_by')->nullable()->index();
            $table->unsignedInteger('deleted_by')->nullable()->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });

        // If the package table exists then seed the package
        if (Schema::hasTable('packages')) {
            Artisan::call('db:seed', ['--class' => PackageSeeder::class, '--force' => true]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists(Str::plural('review'));
    }
}
