<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class AddDateColumnToReviewsTable.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
class AddDateColumnToReviewsTable extends Migration
{
    /**
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('reviews', 'date')) {
            Schema::table('reviews', function (Blueprint $table) {
                $table->string('date')->nullable()->index()->after('uuid');
            });
        }
    }

    /**
     * @return void
     */
    public function down()
    {
        Schema::table('reviews', function (Blueprint $table) {
            $table->dropColumn('date');
        });
    }
}
