<?php

namespace Bongo\Review\Models;

use Bongo\Framework\Traits\HasDate;
use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasContent;
use Bongo\Framework\Traits\HasStatus;
use Bongo\Framework\Traits\HasUUID;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Review.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Review\Models
 */
class Review extends AbstractModel
{
    const PENDING  = 'pending';
    const ACTIVE   = 'active';
    const INACTIVE = 'inactive';

    use SoftDeletes,
        HasContent,
        HasDate,
        HasStatus,
        HasUUID;

    /**
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
        'date',
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'date',
        'title',
        'content',
        'rating',
        'status',
        'name',
        'email',
    ];
}
