<?php

namespace Bongo\Review;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\Review\Events\ReviewCreated;
use Bongo\Review\Events\ReviewUpdated;
use Bongo\Review\Http\ViewComposers\AverageRatingComposer;
use Bongo\Review\Http\ViewComposers\LatestReviewComposer;
use Bongo\Review\Http\ViewComposers\NumberOfReviewsComposer;
use Bongo\Review\Listeners\ClearReviewCache;
use Bongo\Sitemap\Listeners\UpdateSitemap;

/**
 * Class ReviewServiceProvider.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Review
 */
class ReviewServiceProvider extends AbstractServiceProvider
{
    /**
     * @var string
     */
    protected $module = 'review';

    /**
     * Composers.
     *
     * @var array
     */
    protected $composers = [
        NumberOfReviewsComposer::class => [
            'review::frontend.partials.summary',
        ],
        LatestReviewComposer::class => [
            'review::frontend.partials.summary',
        ],
        AverageRatingComposer::class => [
            'review::frontend.partials.summary',
        ],
    ];

    /**
     * @var array
     */
    protected $listeners = [
        ReviewCreated::class => [
            ClearReviewCache::class
        ],
        ReviewUpdated::class => [
            ClearReviewCache::class,
            UpdateSitemap::class
        ]
    ];
}
