<?php

use Illuminate\Support\Facades\Route;

// Backend Routes...
Route::namespace('Bongo\Review\Http\Controllers')
     ->middleware('web')
     ->group(function () {
         Route::namespace('Backend')
              ->middleware(['auth', 'employee'])
              ->prefix(config('settings.backend_prefix'))
              ->as('backend.')
              ->group(function () {

                  // Review
                  Route::as('review.')
                       ->prefix(config('review.prefix'))
                       ->group(function () {
                           Route::get('/')->name('index')->uses('ReviewController@index');
                           Route::get('create')->name('create')->uses('ReviewController@create');
                           Route::post('store')->name('store')->uses('ReviewController@store');
                           Route::get('datatable')->name('datatable')->uses('ReviewDatatableController@index');

                           // Review/{review}/
                           Route::prefix('{review}')
                                ->group(function () {
                                    Route::get('/')->name('show')->uses('ReviewController@show');
                                    Route::get('edit')->name('edit')->uses('ReviewController@edit');
                                    Route::post('update')->name('update')->uses('ReviewController@update');
                                    Route::delete('delete')->name('destroy')->uses('ReviewController@destroy');
                                });
                       });
              });
     });
